// PCMag_DSS_Select.cpp

#include "stdafx.h"
#include "PCMAG_ORA8.h"
#include "PCMag_DSS_Select.h"

// IMPLEMENT_SERIAL macro calls
IMPLEMENT_SERIAL(CXact_DSS_Select_01,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_02,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_03,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_04,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_05,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_06,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_07,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_08,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_09,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_10,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_11,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_12,CXact,1)
IMPLEMENT_SERIAL(CXact_DSS_Select_13,CXact,1)

// ================================================================================

// CXact_DSS_Select_01

CXact_DSS_Select_01::CXact_DSS_Select_01 (void)
{
	m_szName		= "DSS Select 01";
	m_szDescription = "select count(t_key) from tenpct where t_key <> 0";
	m_szSQL			= "select count(t_key) from tenpct where t_key <> 0";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+01;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_01::~CXact_DSS_Select_01 (void)
{
}

BOOL CXact_DSS_Select_01::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_01::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_01::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_01_NUM_COLS 1
	OCIDefine* pDefineArray[DSS_SELECT_01_NUM_COLS];
	struct DSS_SELECT_01 {
		long count_t_key;
	};
	typedef struct DSS_SELECT_01 DSS_SELECT_01;
	struct DSS_SELECT_01_INDICATORS {
		short count_t_key;
	};
	typedef struct DSS_SELECT_01_INDICATORS DSS_SELECT_01_INDICATORS;
	DSS_SELECT_01 dss_select_01_array[NUM_ROWS];
	DSS_SELECT_01_INDICATORS dss_select_01_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_01_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_01_array[0].count_t_key, (ub2)sizeof(dss_select_01_array[0].count_t_key), SQLT_INT, (dvoid *)&dss_select_01_indicators_array[0].count_t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_01_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_01_array[0]), (ub4)sizeof(dss_select_01_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_01_array[iRowLoop].count_t_key << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_01_array[iRowLoop%NUM_ROWS].count_t_key << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_01_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_02

CXact_DSS_Select_02::CXact_DSS_Select_02 (void)
{
	m_szName		= "DSS Select 02";
	m_szDescription = "select min(u_key) from uniques";
	m_szSQL			= "select min(u_key) from uniques";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+02;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_02::~CXact_DSS_Select_02 (void)
{
}

BOOL CXact_DSS_Select_02::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_02::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_02::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_02_NUM_COLS 1
	OCIDefine* pDefineArray[DSS_SELECT_02_NUM_COLS];
	struct DSS_SELECT_02 {
		int min_u_key;
	};
	typedef struct DSS_SELECT_02 DSS_SELECT_02;
	struct DSS_SELECT_02_INDICATORS {
		short min_u_key;
	};
	typedef struct DSS_SELECT_02_INDICATORS DSS_SELECT_02_INDICATORS;
	DSS_SELECT_02 dss_select_02_array[NUM_ROWS];
	DSS_SELECT_02_INDICATORS dss_select_02_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_02_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_02_array[0].min_u_key, (ub2)sizeof(dss_select_02_array[0].min_u_key), SQLT_INT, (dvoid *)&dss_select_02_indicators_array[0].min_u_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_02_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_02_array[0]), (ub4)sizeof(dss_select_02_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_02_array[iRowLoop].min_u_key << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_02_array[iRowLoop%NUM_ROWS].min_u_key << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_02_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_03

CXact_DSS_Select_03::CXact_DSS_Select_03 (void)
{
	m_szName		= "DSS Select 03";
	m_szDescription = "select max(h_key) from hundred group by h_name order by 1";
	m_szSQL			= "select max(h_key) from hundred group by h_name order by 1";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+03;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_03::~CXact_DSS_Select_03 (void)
{
}

BOOL CXact_DSS_Select_03::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_03::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_03::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_03_NUM_COLS 1
	OCIDefine* pDefineArray[DSS_SELECT_03_NUM_COLS];
	struct DSS_SELECT_03 {
		int max_h_key;
	};
	typedef struct DSS_SELECT_03 DSS_SELECT_03;
	struct DSS_SELECT_03_INDICATORS {
		short max_h_key;
	};
	typedef struct DSS_SELECT_03_INDICATORS DSS_SELECT_03_INDICATORS;
	DSS_SELECT_03 dss_select_03_array[NUM_ROWS];
	DSS_SELECT_03_INDICATORS dss_select_03_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_03_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_03_array[0].max_h_key, (ub2)sizeof(dss_select_03_array[0].max_h_key), SQLT_INT, (dvoid *)&dss_select_03_indicators_array[0].max_h_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_03_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_03_array[0]), (ub4)sizeof(dss_select_03_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_03_array[iRowLoop].max_h_key << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_03_array[iRowLoop%NUM_ROWS].max_h_key << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_03_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_04

CXact_DSS_Select_04::CXact_DSS_Select_04 (void)
{
	m_szName		= "DSS Select 04";
	m_szDescription = "select count(t_key) from tenpct where t_name = 'THE+ASAP+BENCHMARKS+' and t_int <= 100000000 and t_signed between 1 and 99999999 and not (t_float between -450000000 and 450000000) and t_double > 600000000 and t_decim < -600000000";
	m_szSQL			= "select count(t_key) from tenpct where t_name = 'THE+ASAP+BENCHMARKS+' and t_int <= 100000000 and t_signed between 1 and 99999999 and not (t_float between -450000000 and 450000000) and t_double > 600000000 and t_decim < -600000000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+04;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_04::~CXact_DSS_Select_04 (void)
{
}

BOOL CXact_DSS_Select_04::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_04::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_04::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_04_NUM_COLS 1
	OCIDefine* pDefineArray[DSS_SELECT_04_NUM_COLS];
	struct DSS_SELECT_04 {
		long count_t_key;
	};
	typedef struct DSS_SELECT_04 DSS_SELECT_04;
	struct DSS_SELECT_04_INDICATORS {
		short count_t_key;
	};
	typedef struct DSS_SELECT_04_INDICATORS DSS_SELECT_04_INDICATORS;
	DSS_SELECT_04 dss_select_04_array[NUM_ROWS];
	DSS_SELECT_04_INDICATORS dss_select_04_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_04_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_04_array[0].count_t_key, (ub2)sizeof(dss_select_04_array[0].count_t_key), SQLT_INT, (dvoid *)&dss_select_04_indicators_array[0].count_t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_04_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_04_array[0]), (ub4)sizeof(dss_select_04_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_04_array[iRowLoop].count_t_key << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_04_array[iRowLoop%NUM_ROWS].count_t_key << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_04_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_05

CXact_DSS_Select_05::CXact_DSS_Select_05 (void)
{
	m_szName		= "DSS Select 05";
	m_szDescription = "select avg(updates.p_decim) from updates where updates.p_key in (select updates.p_key from updates, hundred where hundred.h_key = updates.p_key and updates.p_decim > 990000000)";
	m_szSQL			= "select avg(updates.p_decim) from updates where updates.p_key in (select updates.p_key from updates, hundred where hundred.h_key = updates.p_key and updates.p_decim > 990000000)";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+05;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_05::~CXact_DSS_Select_05 (void)
{
}

BOOL CXact_DSS_Select_05::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_05::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_05::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_05_NUM_COLS 1
	OCIDefine* pDefineArray[DSS_SELECT_05_NUM_COLS];
	struct DSS_SELECT_05 {
		float average_p_decim;
	};
	typedef struct DSS_SELECT_05 DSS_SELECT_05;
	struct DSS_SELECT_05_INDICATORS {
		short average_p_decim;
	};
	typedef struct DSS_SELECT_05_INDICATORS DSS_SELECT_05_INDICATORS;
	DSS_SELECT_05 dss_select_05_array[NUM_ROWS];
	DSS_SELECT_05_INDICATORS dss_select_05_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_05_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_05_array[0].average_p_decim, (ub2)sizeof(dss_select_05_array[0].average_p_decim), SQLT_FLT, (dvoid *)&dss_select_05_indicators_array[0].average_p_decim, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_05_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_05_array[0]), (ub4)sizeof(dss_select_05_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_05_array[iRowLoop].average_p_decim << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_05_array[iRowLoop%NUM_ROWS].average_p_decim << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_05_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_06

CXact_DSS_Select_06::CXact_DSS_Select_06 (void)
{
	m_szName		= "DSS Select 06";
	m_szDescription = "select avg(r_signed), min(r_signed), max(r_signed), min(r_date), max(r_date), count(distinct r_name), count(r_name) from reportview where r_decim > 980000000 group by r_code, r_int order by 1";
	m_szSQL			= "select avg(r_signed), min(r_signed), max(r_signed), min(r_date), max(r_date), count(distinct r_name), count(r_name) from reportview where r_decim > 980000000 group by r_code, r_int order by 1";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+06;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_06::~CXact_DSS_Select_06 (void)
{
}

BOOL CXact_DSS_Select_06::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_06::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_06::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_06_NUM_COLS 7
	OCIDefine* pDefineArray[DSS_SELECT_06_NUM_COLS];
	struct DSS_SELECT_06 {
		float average_r_signed;
		int min_r_signed;
		int max_r_signed;
		char min_r_date[10];
		char max_r_date[10];
		long count_distinct_r_name;
		long count_r_name;
	};
	typedef struct DSS_SELECT_06 DSS_SELECT_06;
	struct DSS_SELECT_06_INDICATORS {
		short average_r_signed;
		short min_r_signed;
		short max_r_signed;
		short min_r_date;
		short max_r_date;
		short count_distinct_r_name;
		short count_r_name;
	};
	typedef struct DSS_SELECT_06_INDICATORS DSS_SELECT_06_INDICATORS;
	DSS_SELECT_06 dss_select_06_array[NUM_ROWS];
	DSS_SELECT_06_INDICATORS dss_select_06_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_06_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_06_array[0].average_r_signed, (ub2)sizeof(dss_select_06_array[0].average_r_signed), SQLT_FLT, (dvoid *)&dss_select_06_indicators_array[0].average_r_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&dss_select_06_array[0].min_r_signed, (ub2)sizeof(dss_select_06_array[0].min_r_signed), SQLT_INT, (dvoid *)&dss_select_06_indicators_array[0].min_r_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&dss_select_06_array[0].max_r_signed, (ub2)sizeof(dss_select_06_array[0].max_r_signed), SQLT_INT, (dvoid *)&dss_select_06_indicators_array[0].max_r_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&dss_select_06_array[0].min_r_date, (ub2)sizeof(dss_select_06_array[0].min_r_date), SQLT_STR, (dvoid *)&dss_select_06_indicators_array[0].min_r_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)&dss_select_06_array[0].max_r_date, (ub2)sizeof(dss_select_06_array[0].max_r_date), SQLT_STR, (dvoid *)&dss_select_06_indicators_array[0].max_r_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)&dss_select_06_array[0].count_distinct_r_name, (ub2)sizeof(dss_select_06_array[0].count_distinct_r_name), SQLT_INT, (dvoid *)&dss_select_06_indicators_array[0].count_distinct_r_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[6], pError, 7, (dvoid *)&dss_select_06_array[0].count_r_name, (ub2)sizeof(dss_select_06_array[0].count_r_name), SQLT_INT, (dvoid *)&dss_select_06_indicators_array[0].count_r_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_06_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_06_array[0]), (ub4)sizeof(dss_select_06_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_06_array[iRowLoop].average_r_signed << tab
					<< dss_select_06_array[iRowLoop].min_r_signed << tab
					<< dss_select_06_array[iRowLoop].max_r_signed << tab
					<< dss_select_06_array[iRowLoop].min_r_date << tab
					<< dss_select_06_array[iRowLoop].max_r_date << tab
					<< dss_select_06_array[iRowLoop].count_distinct_r_name << tab
					<< dss_select_06_array[iRowLoop].count_r_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_06_array[iRowLoop%NUM_ROWS].average_r_signed << tab
					<< dss_select_06_array[iRowLoop%NUM_ROWS].min_r_signed << tab
					<< dss_select_06_array[iRowLoop%NUM_ROWS].max_r_signed << tab
					<< dss_select_06_array[iRowLoop%NUM_ROWS].min_r_date << tab
					<< dss_select_06_array[iRowLoop%NUM_ROWS].max_r_date << tab
					<< dss_select_06_array[iRowLoop%NUM_ROWS].count_distinct_r_name << tab
					<< dss_select_06_array[iRowLoop%NUM_ROWS].count_r_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_06_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_07

CXact_DSS_Select_07::CXact_DSS_Select_07 (void)
{
	m_szName		= "DSS Select 07";
	m_szDescription = "select avg(updates.p_signed), min(updates.p_signed), max(updates.p_signed), min(hundred.h_date), max(hundred.h_date), count(distinct hundred.h_name), count(hundred.h_name) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 980000000 group by hundred.h_code, hundred.h_int order by 1";
	m_szSQL			= "select avg(updates.p_signed), min(updates.p_signed), max(updates.p_signed), min(hundred.h_date), max(hundred.h_date), count(distinct hundred.h_name), count(hundred.h_name) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 980000000 group by hundred.h_code, hundred.h_int order by 1";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+07;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_07::~CXact_DSS_Select_07 (void)
{
}

BOOL CXact_DSS_Select_07::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_07::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_07::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_07_NUM_COLS 7
	OCIDefine* pDefineArray[DSS_SELECT_07_NUM_COLS];
	struct DSS_SELECT_07 {
		float average_p_signed;
		int min_p_signed;
		int max_p_signed;
		char min_h_date[10];
		char max_h_date[10];
		long count_distinct_h_name;
		long count_h_name;
	};
	typedef struct DSS_SELECT_07 DSS_SELECT_07;
	struct DSS_SELECT_07_INDICATORS {
		short average_p_signed;
		short min_p_signed;
		short max_p_signed;
		short min_h_date;
		short max_h_date;
		short count_distinct_h_name;
		short count_h_name;
	};
	typedef struct DSS_SELECT_07_INDICATORS DSS_SELECT_07_INDICATORS;
	DSS_SELECT_07 dss_select_07_array[NUM_ROWS];
	DSS_SELECT_07_INDICATORS dss_select_07_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_07_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_07_array[0].average_p_signed, (ub2)sizeof(dss_select_07_array[0].average_p_signed), SQLT_FLT, (dvoid *)&dss_select_07_indicators_array[0].average_p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&dss_select_07_array[0].min_p_signed, (ub2)sizeof(dss_select_07_array[0].min_p_signed), SQLT_INT, (dvoid *)&dss_select_07_indicators_array[0].min_p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&dss_select_07_array[0].max_p_signed, (ub2)sizeof(dss_select_07_array[0].max_p_signed), SQLT_INT, (dvoid *)&dss_select_07_indicators_array[0].max_p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&dss_select_07_array[0].min_h_date, (ub2)sizeof(dss_select_07_array[0].min_h_date), SQLT_STR, (dvoid *)&dss_select_07_indicators_array[0].min_h_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)&dss_select_07_array[0].max_h_date, (ub2)sizeof(dss_select_07_array[0].max_h_date), SQLT_STR, (dvoid *)&dss_select_07_indicators_array[0].max_h_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)&dss_select_07_array[0].count_distinct_h_name, (ub2)sizeof(dss_select_07_array[0].count_distinct_h_name), SQLT_INT, (dvoid *)&dss_select_07_indicators_array[0].count_distinct_h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[6], pError, 7, (dvoid *)&dss_select_07_array[0].count_h_name, (ub2)sizeof(dss_select_07_array[0].count_h_name), SQLT_INT, (dvoid *)&dss_select_07_indicators_array[0].count_h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_07_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_07_array[0]), (ub4)sizeof(dss_select_07_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_07_array[iRowLoop].average_p_signed << tab
					<< dss_select_07_array[iRowLoop].min_p_signed << tab
					<< dss_select_07_array[iRowLoop].max_p_signed << tab
					<< dss_select_07_array[iRowLoop].min_h_date << tab
					<< dss_select_07_array[iRowLoop].max_h_date << tab
					<< dss_select_07_array[iRowLoop].count_distinct_h_name << tab
					<< dss_select_07_array[iRowLoop].count_h_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_07_array[iRowLoop%NUM_ROWS].average_p_signed << tab
					<< dss_select_07_array[iRowLoop%NUM_ROWS].min_p_signed << tab
					<< dss_select_07_array[iRowLoop%NUM_ROWS].max_p_signed << tab
					<< dss_select_07_array[iRowLoop%NUM_ROWS].min_h_date << tab
					<< dss_select_07_array[iRowLoop%NUM_ROWS].max_h_date << tab
					<< dss_select_07_array[iRowLoop%NUM_ROWS].count_distinct_h_name << tab
					<< dss_select_07_array[iRowLoop%NUM_ROWS].count_h_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_07_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_08

CXact_DSS_Select_08::CXact_DSS_Select_08 (void)
{
	m_szName		= "DSS Select 08";
	m_szDescription = "select min(r_signed), max(r_signed), min(r_date), max(r_date), count(distinct r_name), count(r_name), count(r_code), count(r_int) from reportview where r_decim > 900000000";
	m_szSQL			= "select min(r_signed), max(r_signed), min(r_date), max(r_date), count(distinct r_name), count(r_name), count(r_code), count(r_int) from reportview where r_decim > 900000000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+8;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_08::~CXact_DSS_Select_08 (void)
{
}

BOOL CXact_DSS_Select_08::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_08::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_08::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_08_NUM_COLS 8
	OCIDefine* pDefineArray[DSS_SELECT_08_NUM_COLS];
	struct DSS_SELECT_08 {
		int min_r_signed;
		int max_r_signed;
		char min_r_date[10];
		char max_r_date[10];
		long count_distinct_r_name;
		long count_r_name;
		long count_r_code;
		long count_r_int;
	};
	typedef struct DSS_SELECT_08 DSS_SELECT_08;
	struct DSS_SELECT_08_INDICATORS {
		short min_r_signed;
		short max_r_signed;
		short min_r_date;
		short max_r_date;
		short count_distinct_r_name;
		short count_r_name;
		short count_r_code;
		short count_r_int;
	};
	typedef struct DSS_SELECT_08_INDICATORS DSS_SELECT_08_INDICATORS;
	DSS_SELECT_08 dss_select_08_array[NUM_ROWS];
	DSS_SELECT_08_INDICATORS dss_select_08_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_08_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_08_array[0].min_r_signed, (ub2)sizeof(dss_select_08_array[0].min_r_signed), SQLT_INT, (dvoid *)&dss_select_08_indicators_array[0].min_r_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&dss_select_08_array[0].max_r_signed, (ub2)sizeof(dss_select_08_array[0].max_r_signed), SQLT_INT, (dvoid *)&dss_select_08_indicators_array[0].max_r_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&dss_select_08_array[0].min_r_date, (ub2)sizeof(dss_select_08_array[0].min_r_date), SQLT_STR, (dvoid *)&dss_select_08_indicators_array[0].min_r_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&dss_select_08_array[0].max_r_date, (ub2)sizeof(dss_select_08_array[0].max_r_date), SQLT_STR, (dvoid *)&dss_select_08_indicators_array[0].max_r_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)&dss_select_08_array[0].count_distinct_r_name, (ub2)sizeof(dss_select_08_array[0].count_distinct_r_name), SQLT_INT, (dvoid *)&dss_select_08_indicators_array[0].count_distinct_r_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)&dss_select_08_array[0].count_r_name, (ub2)sizeof(dss_select_08_array[0].count_r_name), SQLT_INT, (dvoid *)&dss_select_08_indicators_array[0].count_r_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[6], pError, 7, (dvoid *)&dss_select_08_array[0].count_r_code, (ub2)sizeof(dss_select_08_array[0].count_r_code), SQLT_INT, (dvoid *)&dss_select_08_indicators_array[0].count_r_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[7], pError, 8, (dvoid *)&dss_select_08_array[0].count_r_int, (ub2)sizeof(dss_select_08_array[0].count_r_int), SQLT_INT, (dvoid *)&dss_select_08_indicators_array[0].count_r_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_08_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_08_array[0]), (ub4)sizeof(dss_select_08_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;
	
	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_08_array[iRowLoop].min_r_signed << tab
					<< dss_select_08_array[iRowLoop].max_r_signed << tab
					<< dss_select_08_array[iRowLoop].min_r_date << tab
					<< dss_select_08_array[iRowLoop].max_r_date << tab
					<< dss_select_08_array[iRowLoop].count_distinct_r_name << tab
					<< dss_select_08_array[iRowLoop].count_r_name << tab
					<< dss_select_08_array[iRowLoop].count_r_code << tab
					<< dss_select_08_array[iRowLoop].count_r_int << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_08_array[iRowLoop%NUM_ROWS].min_r_signed << tab
					<< dss_select_08_array[iRowLoop%NUM_ROWS].max_r_signed << tab
					<< dss_select_08_array[iRowLoop%NUM_ROWS].min_r_date << tab
					<< dss_select_08_array[iRowLoop%NUM_ROWS].max_r_date << tab
					<< dss_select_08_array[iRowLoop%NUM_ROWS].count_distinct_r_name << tab
					<< dss_select_08_array[iRowLoop%NUM_ROWS].count_r_name << tab
					<< dss_select_08_array[iRowLoop%NUM_ROWS].count_r_code << tab
					<< dss_select_08_array[iRowLoop%NUM_ROWS].count_r_int << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_08_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_09

CXact_DSS_Select_09::CXact_DSS_Select_09 (void)
{
	m_szName		= "DSS Select 09";
	m_szDescription = "select min(updates.p_signed), max(updates.p_signed), min(updates.p_date), max(updates.p_date), count(distinct hundred.h_name), count(hundred.h_name), count(hundred.h_code), count(hundred.h_int) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 900000000";
	m_szSQL			= "select min(updates.p_signed), max(updates.p_signed), min(updates.p_date), max(updates.p_date), count(distinct hundred.h_name), count(hundred.h_name), count(hundred.h_code), count(hundred.h_int) from updates, hundred where updates.p_key = hundred.h_key and updates.p_decim > 900000000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+9;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_09::~CXact_DSS_Select_09 (void)
{
}

BOOL CXact_DSS_Select_09::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_09::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_09::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_09_NUM_COLS 8
	OCIDefine* pDefineArray[DSS_SELECT_09_NUM_COLS];
	struct DSS_SELECT_09 {
		int min_p_signed;
		int max_p_signed;
		char min_p_date[10];
		char max_p_date[10];
		long count_distinct_h_name;
		long count_h_name;
		long count_h_code;
		long count_h_int;
	};
	typedef struct DSS_SELECT_09 DSS_SELECT_09;
	struct DSS_SELECT_09_INDICATORS {
		short min_p_signed;
		short max_p_signed;
		short min_p_date;
		short max_p_date;
		short count_distinct_h_name;
		short count_h_name;
		short count_h_code;
		short count_h_int;
	};
	typedef struct DSS_SELECT_09_INDICATORS DSS_SELECT_09_INDICATORS;
	DSS_SELECT_09 dss_select_09_array[NUM_ROWS];
	DSS_SELECT_09_INDICATORS dss_select_09_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_09_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_09_array[0].min_p_signed, (ub2)sizeof(dss_select_09_array[0].min_p_signed), SQLT_INT, (dvoid *)&dss_select_09_indicators_array[0].min_p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&dss_select_09_array[0].max_p_signed, (ub2)sizeof(dss_select_09_array[0].max_p_signed), SQLT_INT, (dvoid *)&dss_select_09_indicators_array[0].max_p_signed, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[2], pError, 3, (dvoid *)&dss_select_09_array[0].min_p_date, (ub2)sizeof(dss_select_09_array[0].min_p_date), SQLT_STR, (dvoid *)&dss_select_09_indicators_array[0].min_p_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[3], pError, 4, (dvoid *)&dss_select_09_array[0].max_p_date, (ub2)sizeof(dss_select_09_array[0].max_p_date), SQLT_STR, (dvoid *)&dss_select_09_indicators_array[0].max_p_date, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[4], pError, 5, (dvoid *)&dss_select_09_array[0].count_distinct_h_name, (ub2)sizeof(dss_select_09_array[0].count_distinct_h_name), SQLT_INT, (dvoid *)&dss_select_09_indicators_array[0].count_distinct_h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[5], pError, 6, (dvoid *)&dss_select_09_array[0].count_h_name, (ub2)sizeof(dss_select_09_array[0].count_h_name), SQLT_INT, (dvoid *)&dss_select_09_indicators_array[0].count_h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[6], pError, 7, (dvoid *)&dss_select_09_array[0].count_h_code, (ub2)sizeof(dss_select_09_array[0].count_h_code), SQLT_INT, (dvoid *)&dss_select_09_indicators_array[0].count_h_code, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[7], pError, 8, (dvoid *)&dss_select_09_array[0].count_h_int, (ub2)sizeof(dss_select_09_array[0].count_h_int), SQLT_INT, (dvoid *)&dss_select_09_indicators_array[0].count_h_int, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_09_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_09_array[0]), (ub4)sizeof(dss_select_09_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_09_array[iRowLoop].min_p_signed << tab
					<< dss_select_09_array[iRowLoop].max_p_signed << tab
					<< dss_select_09_array[iRowLoop].min_p_date << tab
					<< dss_select_09_array[iRowLoop].max_p_date << tab
					<< dss_select_09_array[iRowLoop].count_distinct_h_name << tab
					<< dss_select_09_array[iRowLoop].count_h_name << tab
					<< dss_select_09_array[iRowLoop].count_h_code << tab
					<< dss_select_09_array[iRowLoop].count_h_int << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_09_array[iRowLoop%NUM_ROWS].min_p_signed << tab
					<< dss_select_09_array[iRowLoop%NUM_ROWS].max_p_signed << tab
					<< dss_select_09_array[iRowLoop%NUM_ROWS].min_p_date << tab
					<< dss_select_09_array[iRowLoop%NUM_ROWS].max_p_date << tab
					<< dss_select_09_array[iRowLoop%NUM_ROWS].count_distinct_h_name << tab
					<< dss_select_09_array[iRowLoop%NUM_ROWS].count_h_name << tab
					<< dss_select_09_array[iRowLoop%NUM_ROWS].count_h_code << tab
					<< dss_select_09_array[iRowLoop%NUM_ROWS].count_h_int << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_09_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_10

CXact_DSS_Select_10::CXact_DSS_Select_10 (void)
{
	m_szName		= "DSS Select 10";
	m_szDescription = "select h_name, count(h_name) from hundred group by h_name order by 2";
	m_szSQL			= "select h_name, count(h_name) from hundred group by h_name order by 2";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+10;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_10::~CXact_DSS_Select_10 (void)
{
}

BOOL CXact_DSS_Select_10::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_10::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_10::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_10_NUM_COLS 2
	OCIDefine* pDefineArray[DSS_SELECT_10_NUM_COLS];
	struct DSS_SELECT_10 {
		char h_name[21];
		long count_h_name;
	};
	typedef struct DSS_SELECT_10 DSS_SELECT_10;
	struct DSS_SELECT_10_INDICATORS {
		short h_name;
		short count_h_name;
	};
	typedef struct DSS_SELECT_10_INDICATORS DSS_SELECT_10_INDICATORS;
	DSS_SELECT_10 dss_select_10_array[NUM_ROWS];
	DSS_SELECT_10_INDICATORS dss_select_10_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_10_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_10_array[0].h_name, (ub2)sizeof(dss_select_10_array[0].h_name), SQLT_STR, (dvoid *)&dss_select_10_indicators_array[0].h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[1], pError, 2, (dvoid *)&dss_select_10_array[0].count_h_name, (ub2)sizeof(dss_select_10_array[0].count_h_name), SQLT_INT, (dvoid *)&dss_select_10_indicators_array[0].count_h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_10_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_10_array[0]), (ub4)sizeof(dss_select_10_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_10_array[iRowLoop].h_name << tab
					<< dss_select_10_array[iRowLoop].count_h_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_10_array[iRowLoop%NUM_ROWS].h_name << tab
					<< dss_select_10_array[iRowLoop%NUM_ROWS].count_h_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_10_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_11

CXact_DSS_Select_11::CXact_DSS_Select_11 (void)
{
	m_szName		= "DSS Select 11";
	m_szDescription = "select h_name from hundred group by h_name having count(h_name) > 10 order by h_name";
	m_szSQL			= "select h_name from hundred group by h_name having count(h_name) > 10 order by h_name";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+11;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_11::~CXact_DSS_Select_11 (void)
{
}

BOOL CXact_DSS_Select_11::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_11::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_11::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_11_NUM_COLS 1
	OCIDefine* pDefineArray[DSS_SELECT_11_NUM_COLS];
	struct DSS_SELECT_11 {
		char h_name[21];
	};
	typedef struct DSS_SELECT_11 DSS_SELECT_11;
	struct DSS_SELECT_11_INDICATORS {
		short h_name;
	};
	typedef struct DSS_SELECT_11_INDICATORS DSS_SELECT_11_INDICATORS;
	DSS_SELECT_11 dss_select_11_array[NUM_ROWS];
	DSS_SELECT_11_INDICATORS dss_select_11_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_11_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_11_array[0].h_name, (ub2)sizeof(dss_select_11_array[0].h_name), SQLT_STR, (dvoid *)&dss_select_11_indicators_array[0].h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_11_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_11_array[0]), (ub4)sizeof(dss_select_11_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_11_array[iRowLoop].h_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_11_array[iRowLoop%NUM_ROWS].h_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_11_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_12

CXact_DSS_Select_12::CXact_DSS_Select_12 (void)
{
	m_szName		= "DSS Select 12";
	m_szDescription = "select count(h_name) from hunthou where h_float > (select avg(h_float) from hunthou)";
	m_szSQL			= "select count(h_name) from hunthou where h_float > (select avg(h_float) from hunthou)";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+12;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_12::~CXact_DSS_Select_12 (void)
{
}

BOOL CXact_DSS_Select_12::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_12::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_12::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_12_NUM_COLS 1
	OCIDefine* pDefineArray[DSS_SELECT_12_NUM_COLS];
	struct DSS_SELECT_12 {
		long count_h_name;
	};
	typedef struct DSS_SELECT_12 DSS_SELECT_12;
	struct DSS_SELECT_12_INDICATORS {
		short count_h_name;
	};
	typedef struct DSS_SELECT_12_INDICATORS DSS_SELECT_12_INDICATORS;
	DSS_SELECT_12 dss_select_12_array[NUM_ROWS];
	DSS_SELECT_12_INDICATORS dss_select_12_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_12_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_12_array[0].count_h_name, (ub2)sizeof(dss_select_12_array[0].count_h_name), SQLT_INT, (dvoid *)&dss_select_12_indicators_array[0].count_h_name, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_12_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_12_array[0]), (ub4)sizeof(dss_select_12_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_12_array[iRowLoop].count_h_name << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_12_array[iRowLoop%NUM_ROWS].count_h_name << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_12_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}

// ================================================================================

// CXact_DSS_Select_13

CXact_DSS_Select_13::CXact_DSS_Select_13 (void)
{
	m_szName		= "DSS Select 13";
	m_szDescription = "select count(t_key) from threemill where t_signed <= -250000000";
	m_szSQL			= "select count(t_key) from threemill where t_signed <= -250000000";
	m_nXactType		= TRANSACTION;
	m_nXID			= XID_DSS_SELECT+13;
	m_nGID			= DSSSelect;
}

CXact_DSS_Select_13::~CXact_DSS_Select_13 (void)
{
}

BOOL CXact_DSS_Select_13::PreBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogon ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_13::PostBenchmark (void)
{
	#if (_NOBF_ORA8_ == TRUE)
		pSQLDatabaseServer->DatabaseLogoff ();
	#endif
	return TRUE;
}

BOOL CXact_DSS_Select_13::Execute (void)
{

	// declare variables
	COracle8Driver *pSQLDatabaseServer;
	OCIEnv* pEnvironment;
	OCIError* pError;
	OCISvcCtx* pServerContext;
	int iRowLoop;
	int iColLoop;
	sword ReturnCode;
	sword ExecuteReturnCode;
	OCIStmt* pStmt;
#define DSS_SELECT_13_NUM_COLS 1
	OCIDefine* pDefineArray[DSS_SELECT_13_NUM_COLS];
	struct DSS_SELECT_13 {
		long count_t_key;
	};
	typedef struct DSS_SELECT_13 DSS_SELECT_13;
	struct DSS_SELECT_13_INDICATORS {
		short count_t_key;
	};
	typedef struct DSS_SELECT_13_INDICATORS DSS_SELECT_13_INDICATORS;
	DSS_SELECT_13 dss_select_13_array[NUM_ROWS];
	DSS_SELECT_13_INDICATORS dss_select_13_indicators_array[NUM_ROWS];

	// initialize variables
	for (iColLoop = 0; iColLoop < DSS_SELECT_13_NUM_COLS; iColLoop++) {
		pDefineArray[iColLoop] = (OCIDefine *)NULL;
	}
	#if (_NOBF_ORA8_ == FALSE)
		pSQLDatabaseServer = (COracle8Driver*) m_pCSQLObject;
	#endif
	pEnvironment = pSQLDatabaseServer->GetOCIEnvironment();
	pError = pSQLDatabaseServer->GetOCIError();
	pServerContext = pSQLDatabaseServer->GetOCIServerContext();

	// allocate a statement handle
	ReturnCode = OCIHandleAlloc (pEnvironment, (dvoid**)&pStmt, OCI_HTYPE_STMT, (size_t)0, (dvoid**)NULL);
	CHECK_FOR_ERROR;
	
	// prepare the statement
	ReturnCode = OCIStmtPrepare (pStmt, pError, (UCHAR *)m_szSQL.GetBuffer(0), m_szSQL.GetLength(), OCI_NTV_SYNTAX, OCI_DEFAULT);
	m_szSQL.ReleaseBuffer();
	CHECK_FOR_ERROR;
	
	// bind output variables
	ReturnCode = OCIDefineByPos (pStmt, &pDefineArray[0], pError, 1, (dvoid *)&dss_select_13_array[0].count_t_key, (ub2)sizeof(dss_select_13_array[0].count_t_key), SQLT_INT, (dvoid *)&dss_select_13_indicators_array[0].count_t_key, (ub2 *) 0, (ub2 *) 0, OCI_DEFAULT);
	CHECK_FOR_ERROR;

	// set statement attributes
	ReturnCode = OCIAttrSet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&NUM_ROWS, (ub4)sizeof(NUM_ROWS), OCI_ATTR_PREFETCH_ROWS, pError);
	CHECK_FOR_ERROR;
	for (iColLoop = 0; iColLoop < DSS_SELECT_13_NUM_COLS; iColLoop++) {
		ReturnCode = OCIDefineArrayOfStruct (pDefineArray[iColLoop], pError, (ub4)sizeof(dss_select_13_array[0]), (ub4)sizeof(dss_select_13_indicators_array[0]), 0, 0);
		CHECK_FOR_ERROR;
	}

	// ==========
	
	// start timer
	m_CTimer.SetStartTime();

	// execute the statement and fetch the first set of rows
	ExecuteReturnCode = OCIStmtExecute (pServerContext, pStmt, pError, NUM_ROWS, (ub4) 0, (OCISnapshot *) NULL, (OCISnapshot *) NULL, OCI_DEFAULT);
	CHECK_FOR_ERROR_EXECUTE;

	// query has been processed and first results fetched, record response time
	m_CTimer.SetResponseTime();

	// find number of rows returned so far
	ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
	CHECK_FOR_ERROR;

	// output data to log if requested
	if (OutputResults()) {
		for (iRowLoop = 0; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_13_array[iRowLoop].count_t_key << endl;
	}

	// fetch loop (if more data exists)
	while (ExecuteReturnCode != OCI_NO_DATA) {

		// check for user cancel
		if (CancelXact()) {
				m_CTimer.SetEndTime(m_nTotalRows, m_nTotalBytes);
				ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
				CHECK_FOR_ERROR;
				return FALSE;
		}

		// array fetch the rest of the data
		ExecuteReturnCode = OCIStmtFetch (pStmt, pError, NUM_ROWS, OCI_FETCH_NEXT, OCI_DEFAULT);
		CHECK_FOR_ERROR_EXECUTE;

		// find number of rows returned so far
		ReturnCode = OCIAttrGet ((dvoid *)pStmt, OCI_HTYPE_STMT, (dvoid *)&m_nTotalRows, (ub4 *) NULL, OCI_ATTR_ROW_COUNT, pError);
		CHECK_FOR_ERROR;

		// output data to log if requested
		if (OutputResults()) {
			for (; iRowLoop < m_nTotalRows; iRowLoop++)
				GetResultsFile() 
					<< dss_select_13_array[iRowLoop%NUM_ROWS].count_t_key << endl;
		}

	}

	// update statistics
	m_nTotalBytes = m_nTotalRows * sizeof(dss_select_13_array[0]);

	// set end time
	m_CTimer.SetEndTime (m_nTotalRows, m_nTotalBytes);

	// free handle
	ReturnCode = OCIHandleFree (pStmt, OCI_HTYPE_STMT);
	CHECK_FOR_ERROR;

	// return
	return TRUE;

}
